%%
A = imread('image2.jpg');
imshow(A);

%% convert A to grayscale image
A_gray = rgb2gray(A);
figure;
imshow(A_gray);

%% r,g,b channels of A
A_r = A(:,:,1);
A_g = A(:,:,2);
A_b = A(:,:,3);

A_red = A;
A_green = A;
A_blue = A;
A_red(:,:,2) = 0; A_red(:,:,3) = 0; % green and blue channels become zero.
A_green(:,:,1) = 0; A_green(:,:,3) = 0; % red and blue channels become zero.
A_blue(:,:,1) = 0; A_blue(:,:,2) = 0; % red and green channels become zero.

%% show a sequence of images (r,g,b channels of A) using montage
figure;
montage({A,A_red,A_green,A_blue},'size',[4,1]);

%% HSV (Hue, Saturation, Value)
A_hsv = rgb2hsv(A); %% Obtain hsv information from rgb infornation
A_h = A_hsv(:,:,1); 
A_s = A_hsv(:,:,2);
A_v = A_hsv(:,:,3);

A1_hsv = A_hsv;
A1_hsv(:,:,3) = 0.4; %% brightness become constant
A1 = hsv2rgb(A1_hsv); %% retrieve rgb informtion from hsv information.

A2_hsv = A_hsv;
A2_hsv(:,:,2) = A2_hsv(:,:,2)*0.5; %% Saturation * 0.5
A2 = hsv2rgb(A2_hsv); %% retrieve rgb informtion from hsv information.

A3_hsv = A_hsv;
A3_hsv(:,:,1) = 0.3; %% identical hue
A3 = hsv2rgb(A3_hsv); %% retrieve rgb informtion from hsv information.

figure;
montage({A,A1,A2,A3},'size',[2 2]);






